<?php
class DateHeure {
	/** @var int date au format AAAAMMJJ */
	public $date;

	/** @var int heure au format HHMM*/
	public $heure;

	/** @var int timestamp, l'instant a convertir
	 * @access private
	 */
	private $ts;	// Normalement, celui-ci ne devrait pas etre exporte car privavee

	/**
	 * Constructeur de DateHeure
	 *
	 * @param int $ats timestamp a convertir, si NULL, c'est on prend l'heure actuelle
	 */
	public function __construct($ats = NULL){
		$this->ts = $ats ? $ats : time();

		$this->date = Date('Ymd', $this->ts);
		$this->heure = Date('His', $this->ts);
	}
}

class Horloge {
	/**
	 * Classe de test qui renvoie l'heure et la date
	 *
	 * @return DateHeure bla bla
	 */
	public function QuelleHeure(){
		return new DateHeure();
	}


	/**
	 * Classe de test qui renvoie l'heure et la date d'un timestamp
	 *
	 * @param int $ts bla bla
	 * @return DateHeure  bla bla
	 */
	public function QuelleHeureEtaitIl( $ts ){
		return new DateHeure( $ts );
	}
}
?>
